import * as React from "react"
import { cva, type VariantProps } from "class-variance-authority"
import { cn } from "@/lib/utils"

const badgeVariants = cva(
  "inline-flex items-center rounded-full border px-2.5 py-0.5 text-xs font-semibold transition-colors focus:outline-none focus:ring-2 focus:ring-ring focus:ring-offset-2",
  {
    variants: {
      variant: {
        default:
          "border-transparent bg-brand-primary text-white hover:bg-brand-secondary/80",
        secondary:
          "border-transparent bg-slate-100 text-slate-900 hover:bg-slate-100/80",
        outline: "text-foreground",
        flow: "border-transparent bg-product-flow/10 text-product-flow hover:bg-product-flow/20",
        fleet: "border-transparent bg-product-fleet/10 text-product-fleet hover:bg-product-fleet/20",
        travel: "border-transparent bg-product-travel/10 text-product-travel hover:bg-product-travel/20",
        weave: "border-transparent bg-product-weave/10 text-product-weave hover:bg-product-weave/20",
        orbit: "border-transparent bg-product-orbit/10 text-product-orbit hover:bg-product-orbit/20",
      },
    },
    defaultVariants: {
      variant: "default",
    },
  }
)

export interface BadgeProps
  extends React.HTMLAttributes<HTMLDivElement>,
    VariantProps<typeof badgeVariants> {}

function Badge({ className, variant, ...props }: BadgeProps) {
  return (
    <div className={cn(badgeVariants({ variant }), className)} {...props} />
  )
}

export { Badge, badgeVariants }
