"use client";

import { Card, CardContent } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { motion } from "framer-motion";

interface TechnologiesProps {
  dict: any;
}

export function Technologies({ dict }: TechnologiesProps) {
  const techCategories = [
    {
      category: "Frontend",
      color: "bg-blue-500",
      technologies: [
        { name: "React", icon: "⚛️" },
        { name: "Next.js", icon: "▲" },
        { name: "TypeScript", icon: "TS" },
        { name: "Tailwind CSS", icon: "🎨" },
      ],
    },
    {
      category: "Backend",
      color: "bg-green-500",
      technologies: [
        { name: "Node.js", icon: "🟢" },
        { name: "Python", icon: "🐍" },
        { name: "PostgreSQL", icon: "🐘" },
        { name: "Redis", icon: "🔴" },
      ],
    },
    {
      category: "Cloud & DevOps",
      color: "bg-purple-500",
      technologies: [
        { name: "AWS", icon: "☁️" },
        { name: "Docker", icon: "🐳" },
        { name: "Kubernetes", icon: "☸️" },
        { name: "GitHub Actions", icon: "⚙️" },
      ],
    },
    {
      category: "Mobile",
      color: "bg-orange-500",
      technologies: [
        { name: "React Native", icon: "📱" },
        { name: "Flutter", icon: "🦋" },
        { name: "iOS", icon: "🍎" },
        { name: "Android", icon: "🤖" },
      ],
    },
  ];

  return (
    <section id="tech" className="py-20 md:py-32 relative overflow-hidden">
      {/* Background Pattern */}
      <div className="absolute inset-0 opacity-5">
        <div className="absolute top-0 left-1/4 w-96 h-96 bg-brand-primary rounded-full blur-3xl"></div>
        <div className="absolute bottom-0 right-1/4 w-96 h-96 bg-brand-secondary rounded-full blur-3xl"></div>
      </div>
      
      <div className="container px-4 md:px-6 relative z-10">
        <div className="max-w-3xl mx-auto text-center mb-16">
          <h2 className="text-3xl md:text-5xl font-bold tracking-tighter mb-4">
            {dict.title}
          </h2>
          <p className="text-lg md:text-xl text-text-secondary">
            {dict.desc}
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6 max-w-7xl mx-auto">
          {techCategories.map((category, categoryIndex) => (
            <motion.div
              key={categoryIndex}
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              transition={{ delay: categoryIndex * 0.1 }}
              viewport={{ once: true }}
            >
              <Card className="h-full hover:shadow-lg transition-shadow">
                <CardContent className="p-6 space-y-4">
                  <div className="flex items-center gap-3 mb-4">
                    <div className={`w-3 h-3 rounded-full ${category.color}`}></div>
                    <h3 className="text-lg font-semibold">{category.category}</h3>
                  </div>
                  <div className="space-y-2">
                    {category.technologies.map((tech, techIndex) => (
                      <div
                        key={techIndex}
                        className="flex items-center gap-2 p-2 rounded-lg hover:bg-gray-50 transition-colors"
                      >
                        <span className="text-2xl">{tech.icon}</span>
                        <span className="text-sm font-medium">{tech.name}</span>
                      </div>
                    ))}
                  </div>
                </CardContent>
              </Card>
            </motion.div>
          ))}
        </div>

        {/* Additional Tech Highlights */}
        <div className="mt-12 max-w-4xl mx-auto">
          <div className="flex flex-wrap gap-3 justify-center">
            <Badge variant="secondary" className="px-4 py-2">GraphQL</Badge>
            <Badge variant="secondary" className="px-4 py-2">REST API</Badge>
            <Badge variant="secondary" className="px-4 py-2">WebSockets</Badge>
            <Badge variant="secondary" className="px-4 py-2">Microservices</Badge>
            <Badge variant="secondary" className="px-4 py-2">CI/CD</Badge>
            <Badge variant="secondary" className="px-4 py-2">Agile/Scrum</Badge>
            <Badge variant="secondary" className="px-4 py-2">TDD</Badge>
            <Badge variant="secondary" className="px-4 py-2">Clean Architecture</Badge>
          </div>
        </div>
      </div>
    </section>
  );
}
