"use client";
import { Button } from "@/components/ui/button";
import { motion } from "framer-motion";
import { ArrowRight, Layers } from "lucide-react";
import Link from "next/link";

interface HeroProps {
  dict: any;
  lang?: string;
}

export function Hero({ dict, lang = 'ru' }: HeroProps) {
  const handleScrollToProducts = () => {
    const element = document.getElementById('products');
    element?.scrollIntoView({ behavior: 'smooth' });
  };

  return (
    <section className="relative overflow-hidden bg-bg-light pt-16 pb-32 md:pt-24 md:pb-48">
      {/* Background Decorative Elements */}
      <div className="absolute top-0 left-1/2 -translate-x-1/2 w-full h-full max-w-7xl pointer-events-none opacity-30">
        <div className="absolute top-20 left-10 w-72 h-72 bg-brand-primary/20 rounded-full blur-3xl mix-blend-multiply animate-blob" />
        <div className="absolute top-20 right-10 w-72 h-72 bg-product-weave/20 rounded-full blur-3xl mix-blend-multiply animate-blob animation-delay-2000" />
        <div className="absolute bottom-20 left-1/2 w-72 h-72 bg-product-travel/20 rounded-full blur-3xl mix-blend-multiply animate-blob animation-delay-4000" />
      </div>

      <div className="container px-4 md:px-6 relative z-10 flex flex-col items-center text-center">
        <motion.div
           initial={{ opacity: 0, y: 20 }}
           animate={{ opacity: 1, y: 0 }}
           transition={{ duration: 0.5 }}
           className="inline-flex items-center rounded-full border border-gray-200 bg-white px-3 py-1 text-sm font-medium text-text-secondary mb-6 shadow-sm"
        >
           <span className="flex h-2 w-2 rounded-full bg-green-500 mr-2"></span>
           v2.0 • Enterprise Ready
        </motion.div>

        <motion.h1 
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.5, delay: 0.1 }}
          className="text-4xl md:text-5xl lg:text-7xl font-bold tracking-tight text-text-primary max-w-4xl mb-6 bg-gradient-to-r from-text-primary to-text-secondary bg-clip-text text-transparent"
        >
          {dict.title}
        </motion.h1>

        <motion.p 
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.5, delay: 0.2 }}
          className="text-lg md:text-xl text-text-secondary max-w-2xl mb-8 leading-relaxed"
        >
          {dict.subtitle}
        </motion.p>

        <motion.div 
           initial={{ opacity: 0, y: 20 }}
           animate={{ opacity: 1, y: 0 }}
           transition={{ duration: 0.5, delay: 0.3 }}
           className="flex flex-col sm:flex-row gap-4 w-full sm:w-auto"
        >
          <Button size="lg" className="w-full sm:w-auto gap-2" onClick={handleScrollToProducts}>
            {dict.cta_primary} <ArrowRight className="h-4 w-4" />
          </Button>
          <Link href={`/${lang}/contact`}>
            <Button size="lg" variant="secondary" className="w-full sm:w-auto">
              {dict.cta_secondary}
            </Button>
          </Link>
        </motion.div>

        {/* Hero Visual showing the ecosystem loosely */}
        <motion.div
            initial={{ opacity: 0, scale: 0.9 }}
            animate={{ opacity: 1, scale: 1 }}
            transition={{ duration: 0.8, delay: 0.4 }}
            className="mt-16 relative w-full max-w-5xl aspect-[16/9] rounded-xl border border-gray-200 bg-white shadow-2xl overflow-hidden hidden md:block"
        >
            <img 
              src="https://images.unsplash.com/photo-1551434678-e076c223a692?w=1200&h=675&fit=crop&q=80" 
              alt="Team collaboration workspace" 
              className="w-full h-full object-cover"
            />
            {/* Mock UI Elements */}
             <div className="absolute top-4 left-4 right-4 h-8 bg-white/90 backdrop-blur-sm rounded flex items-center px-4 space-x-2 shadow-sm">
                <div className="w-3 h-3 rounded-full bg-red-400"></div>
                <div className="w-3 h-3 rounded-full bg-yellow-400"></div>
                <div className="w-3 h-3 rounded-full bg-green-400"></div>
                <div className="ml-4 flex-1 h-4 bg-gray-100 rounded"></div>
             </div>
        </motion.div>
      </div>
    </section>
  );
}
