"use client";
import { Button } from "@/components/ui/button";
import Link from "next/link";

interface CTAProps {
    dict: any;
    lang?: string;
}

export function CTA({ dict, lang = 'ru' }: CTAProps) {
    return (
        <section className="py-24 bg-bg-dark text-white relative overflow-hidden">
             {/* Abstract grid background */}
            <div className="absolute inset-0 bg-[url('/grid-pattern.svg')] opacity-5"></div>
            
            <div className="container px-4 md:px-6 relative z-10 text-center">
                <h2 className="text-3xl md:text-4xl font-bold tracking-tighter mb-4 max-w-3xl mx-auto">
                    {dict.title}
                </h2>
                <p className="text-gray-400 max-w-[600px] mx-auto mb-8 text-lg">
                    {dict.desc}
                </p>
                <div className="flex flex-col sm:flex-row justify-center gap-4">
                   <Link href={`/${lang}/contact`}>
                     <Button size="lg" className="bg-white text-bg-dark hover:bg-gray-100">
                      {dict.button}
                     </Button>
                   </Link>
                   <Link href={`/${lang}/contact`}>
                     <Button size="lg" variant="outline" className="border-gray-700 text-white hover:bg-gray-800">
                      {dict.secondary}
                     </Button>
                   </Link>
                </div>
            </div>
        </section>
    )
}
