import '../styles/globals.css'
import type { Metadata } from 'next'
import { Inter, JetBrains_Mono } from 'next/font/google'
import { locales } from '@/lib/i18n'
import Script from 'next/script'

const inter = Inter({ 
  subsets: ['latin', 'cyrillic'],
  variable: '--font-body',
});

const mono = JetBrains_Mono({
  subsets: ['latin'],
  variable: '--font-mono',
});

export const metadata: Metadata = {
  title: {
    template: '%s | RSaSh Lab',
    default: 'RSaSh Lab - Enterprise Software Solutions',
  },
  description: 'RSaSh Lab develops next-generation corporate systems, uniting SaaS solutions for fleet management, logistics, travel, and communications.',
}

export async function generateStaticParams() {
  return locales.map((lang) => ({ lang }));
}

export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html className={`${inter.variable} ${mono.variable}`}>
      <body className="antialiased min-h-screen flex flex-col">
        {children}
        {/* Google Analytics */}
        <Script
          src="https://www.googletagmanager.com/gtag/js?id=G-LMGDQR1GFS"
          strategy="afterInteractive"
        />
        <Script id="google-analytics" strategy="afterInteractive">
          {`
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());

            gtag('config', 'G-LMGDQR1GFS');
          `}
        </Script>
      </body>
    </html>
  )
}
